/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef ALPHABETA_H
#define ALPHABETA_H

#include "game.h"

#define PLY 8

extern volatile bool abort_search;
/* FIXME: these should be long unsigned integers, in case of overflow. */
extern unsigned long long int positions_evaluated;
extern unsigned long long int moves_searched;
extern unsigned long long int positions_in_hashtable;
extern unsigned long long int branches_pruned;
extern unsigned long long int branches_pruned_1st;

void sort_moves(int *move_perm, int num_moves, const int *score);

int alphabeta(gamestate_t *game, int depth, int draft, int alpha, int beta);

bool draw_by_repetition(gamestate_t *game);
int count_repetition(const gamestate_t *game);

#endif
