/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef PAWN_TABLE_H
#define PAWN_TABLE_H

typedef struct {
   uint64_t key;           /* Store the full key (for position verification) */
   int16_t score;          /* The value of this node */
   int16_t free_pawns_mg;  /* Score for free pawns, middle game */
   int16_t free_pawns_eg;  /* score for free pawns, end game */

   /* Some data we may want or need */
#if 0
   bitboard_t duo[2];
   bitboard_t backward_pawns[2];
   bitboard_t isolated_pawns[2];
   bitboard_t connected_pawns[2];
   bitboard_t doubled_pawns[2];
   bitboard_t free_pawns[2];
   uint8_t pawn_files[2];
#endif
   uint8_t open_files;
   uint8_t half_open_files[2];

   bitboard_t doubled_pawns;

   bitboard_t weak;

   /* Free pawns and connected free pawns
    * Stop squares are squares directly in front of the free pawn.
    */
   bitboard_t connected_free;
   bitboard_t free;

   /* Weak squares and outposts */
   bitboard_t outposts[2];
   bitboard_t strong_squares[2];
} pawn_structure_t;

typedef struct {
   pawn_structure_t *data;
   size_t number_of_elements;
} pawn_hash_table_t;

pawn_hash_table_t *create_pawn_hash_table(size_t nelem);
void destroy_pawn_hash_table(pawn_hash_table_t *table);
pawn_structure_t *query_pawn_table_entry(pawn_hash_table_t *table, uint64_t key);

#endif
