/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef PIECES_H
#define PIECES_H

#include <stdint.h>

typedef uint8_t piece_t;

#define NUM_PIECE_TYPES  6

/* Pieces and their symbolic names/bit identifiers */
#define PAWN     0
#define KNIGHT   1
#define BISHOP   2
#define ROOK     3
#define QUEEN    4
#define KING     5

#define NO_PROMOTION    (0)
#define ANY_PROMOTION   (1<<KNIGHT | 1<<BISHOP | 1<<ROOK | 1<<QUEEN)
#define QUEEN_PROMOTION (1<<QUEEN)

/* Bitfield colours */
#define WHITE    0
#define BLACK    128

/* Piece classes */
#define PIECE     (0xff ^ BLACK)

/* Special evaluations */
#define CHECKMATE  16000
#define STALEMATE      0

static inline piece_t piece_for_side(piece_t piece, int side)
{
   return piece | side;
}

static inline int decode_piece_colour(piece_t piece)
{
   return piece & BLACK;
}

static inline piece_t decode_piece_type(piece_t piece)
{
   return piece & PIECE;
}

/* Piece values                      Pawn Knight Bishop Rook Queen King */
extern int chess_piece_values[NUM_PIECE_TYPES];

/* Get the colour of a piece: 0 for white, 1 for black */
static inline uint8_t piece_colour(uint8_t piece)
{
   //return (piece&BLACK) >> 7;
   return piece >> 7;
}

static inline int piece_value(uint8_t piece)
{
   return chess_piece_values[piece&PIECE];
}

#endif
