#ifndef SCOREMOVE_H
#define SCOREMOVE_H

#include "evaluate.h"

/* Symbolic constants for different move scores */
#define SORT_HASHMOVE      (CHECKMATE)
#define SORT_MATEKILLER    (CHECKMATE - 100)
#define SORT_MATEKILLER2   (CHECKMATE - 200)
#define SORT_PROMOTION     (1150)
#define SORT_WINCAPTURE    (1100)
#define SORT_KILLER1       (1100)
#define SORT_KILLER2       (1090)
#define SORT_KILLER3       (1090)
#define SORT_PREVKILLER1   (1080)
#define SORT_PREVKILLER2   (1070)
#define SORT_COUNTER       (1000)
#define SORT_COMBO         (1080)
#define SORT_NULLKILLER    ( 200)
#define SORT_CASTLE        ( 500)
#define SORT_MOVETHREAT    ( 400)

#define REDUCTION_LIMIT    (1000)

int score_moves(const gamestate_t *game, const movelist_t *movelist, int depth, const move_t hash_move, const move_t prev_move, const move_t my_prev_move, const move_t threat_move, int *restrict score, int *restrict move_perm);
int score_moves_qs(const gamestate_t *game, const movelist_t *movelist, int depth, int *restrict score, int *restrict move_perm);

#endif
