/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "jazz.h"

int main(int argc, char **argv)
{
   gamestate_t *game = NULL;
   movelist_t movelist;
   int depth = 12;

   printf("Welcome to Jazz\n");
   printf("Memory sizes:\n"
          " * move_t          : %lu bytes\n"
          " * bitboard_t      : %lu bytes\n"
          " * hash_table_entry: %lu bytes\n"
          " * pawn_structure_t: %lu bytes\n"
          " * piece__square_ta: %lu bytes\n"
          " * board_t         : %lu bytes\n",
          sizeof(move_t),
          sizeof(bitboard_t),
          sizeof(hash_table_entry_t),
          sizeof(pawn_structure_t),
          sizeof(piece_square_table_t),
          sizeof(board_t));
   printf("Size of transposition table: %lu bytes\n",
         sizeof(hash_table_entry_t) * HASH_TABLE_SIZE);

   printf("Initialising Jazz engine\n");
   initialise_jazz();

   if (argc>1) {
      int n;
      for (n=0; n<argc-1; n++) {
         if (strstr(argv[n+1], ".epd")) {
            game = load_epd_file(argv[n+1], 0);

            generate_moves(&movelist, game->board, game->side_to_move);
            print_bitboards(game->board);

            computer_play(game, depth);
            end_game(game);
         } else {
            int new_depth, result;
            
            result = sscanf(argv[n+1], "%d", &new_depth);
            if (result == 1)
               depth = new_depth;
         }
      }
      exit(0);
   }

   printf("Please specify file name\n");
   return 0;
}
