#include "config.h"
#include "game.h"
#include "move.h"
#include "goodcap.h"

/* Store good captures. To qualify as a good capture, the move
 *  - must be a capture (obviously)
 *  - have a nominally bad SEE score
 *  - improve on the actual score
 */
void store_good_capture(gamestate_t *game, move_t move, int score, int depth)
{
#ifdef USE_GOOD_CAPTURE
   if (!is_capture_move(move))
      return;

   if (score > 1100 && !is_good_capture(game, depth, move)) {
      return;
   }

   if (moves_are_equal(move, game->good_capture[0][depth])) {
      /* The move was the first capture - do nothing */
   } else {
      /* This was either the last capture (out of 2 or 3), or it's a new
       * move. Either way, Degrade first capture to second capture (etc) and
       * store the new first capture.
       */
      game->good_capture[1][depth]=game->good_capture[0][depth];
      game->good_capture[0][depth]=move;
   }
#endif
}


bool is_good_capture(const gamestate_t *game, int depth, move_t move)
{
#ifdef USE_GOOD_CAPTURE
   if (moves_are_equal(game->good_capture[0][depth], move) ||
       moves_are_equal(game->good_capture[1][depth], move))
      return true;
#endif
   return false;
}

