/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef MOVELIST_H
#define MOVELIST_H

#include "move.h"

/* datastructure to hold the number of legal moves in a position */
#define MAX_MOVES    256
typedef struct movelist_t {
   move_t move[MAX_MOVES];
   int score[MAX_MOVES];
   int num_moves;
   int cur_move;
} movelist_t;

static inline move_t get_next_move(movelist_t *movelist)
{
   assert(movelist);
   assert(movelist->cur_move < movelist->num_moves);
   move_t move = 0;

   if (movelist->cur_move < movelist->num_moves) {
      int nm = movelist->cur_move;
      int score = movelist->score[nm];
      int n;
      for (n=movelist->cur_move; n<movelist->num_moves; n++) {
         if (movelist->score[n] > movelist->score[nm])
            nm = n;
      }
      n = movelist->cur_move;
      move = movelist->move[n];
      movelist->move[n] = movelist->move[nm];
      movelist->move[nm] = move;
      score = movelist->score[n];
      movelist->score[n] = movelist->score[nm];
      movelist->score[nm] = score;

      move = movelist->move[movelist->cur_move];
      movelist->cur_move++;
   }

   return move;
}

static inline int get_move_score(const movelist_t *movelist)
{
   assert(movelist);
   assert(movelist->cur_move > 0);
   assert(movelist->cur_move-1 < movelist->num_moves);

   return movelist->score[movelist->cur_move-1];
}

#endif
