/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef SQUARE_NAMES_H
#define SQUARE_NAMES_H

/* Symbolic constants: names of the squares on the chess board */
#define A1 0
#define A1_MASK ((uint64_t)1<<A1)
#define B1 1
#define B1_MASK ((uint64_t)1<<B1)
#define C1 2
#define C1_MASK ((uint64_t)1<<C1)
#define D1 3
#define D1_MASK ((uint64_t)1<<D1)
#define E1 4
#define E1_MASK ((uint64_t)1<<E1)
#define F1 5
#define F1_MASK ((uint64_t)1<<F1)
#define G1 6
#define G1_MASK ((uint64_t)1<<G1)
#define H1 7
#define H1_MASK ((uint64_t)1<<H1)
#define A2 8
#define A2_MASK ((uint64_t)1<<A2)
#define B2 9
#define B2_MASK ((uint64_t)1<<B2)
#define C2 10
#define C2_MASK ((uint64_t)1<<C2)
#define D2 11
#define D2_MASK ((uint64_t)1<<D2)
#define E2 12
#define E2_MASK ((uint64_t)1<<E2)
#define F2 13
#define F2_MASK ((uint64_t)1<<F2)
#define G2 14
#define G2_MASK ((uint64_t)1<<G2)
#define H2 15
#define H2_MASK ((uint64_t)1<<H2)
#define A3 16
#define A3_MASK ((uint64_t)1<<A3)
#define B3 17
#define B3_MASK ((uint64_t)1<<B3)
#define C3 18
#define C3_MASK ((uint64_t)1<<C3)
#define D3 19
#define D3_MASK ((uint64_t)1<<D3)
#define E3 20
#define E3_MASK ((uint64_t)1<<E3)
#define F3 21
#define F3_MASK ((uint64_t)1<<F3)
#define G3 22
#define G3_MASK ((uint64_t)1<<G3)
#define H3 23
#define H3_MASK ((uint64_t)1<<H3)
#define A4 24
#define A4_MASK ((uint64_t)1<<A4)
#define B4 25
#define B4_MASK ((uint64_t)1<<B4)
#define C4 26
#define C4_MASK ((uint64_t)1<<C4)
#define D4 27
#define D4_MASK ((uint64_t)1<<D4)
#define E4 28
#define E4_MASK ((uint64_t)1<<E4)
#define F4 29
#define F4_MASK ((uint64_t)1<<F4)
#define G4 30
#define G4_MASK ((uint64_t)1<<G4)
#define H4 31
#define H4_MASK ((uint64_t)1<<H4)
#define A5 32
#define A5_MASK ((uint64_t)1<<A5)
#define B5 33
#define B5_MASK ((uint64_t)1<<B5)
#define C5 34
#define C5_MASK ((uint64_t)1<<C5)
#define D5 35
#define D5_MASK ((uint64_t)1<<D5)
#define E5 36
#define E5_MASK ((uint64_t)1<<E5)
#define F5 37
#define F5_MASK ((uint64_t)1<<F5)
#define G5 38
#define G5_MASK ((uint64_t)1<<G5)
#define H5 39
#define H5_MASK ((uint64_t)1<<H5)
#define A6 40
#define A6_MASK ((uint64_t)1<<A6)
#define B6 41
#define B6_MASK ((uint64_t)1<<B6)
#define C6 42
#define C6_MASK ((uint64_t)1<<C6)
#define D6 43
#define D6_MASK ((uint64_t)1<<D6)
#define E6 44
#define E6_MASK ((uint64_t)1<<E6)
#define F6 45
#define F6_MASK ((uint64_t)1<<F6)
#define G6 46
#define G6_MASK ((uint64_t)1<<G6)
#define H6 47
#define H6_MASK ((uint64_t)1<<H6)
#define A7 48
#define A7_MASK ((uint64_t)1<<A7)
#define B7 49
#define B7_MASK ((uint64_t)1<<B7)
#define C7 50
#define C7_MASK ((uint64_t)1<<C7)
#define D7 51
#define D7_MASK ((uint64_t)1<<D7)
#define E7 52
#define E7_MASK ((uint64_t)1<<E7)
#define F7 53
#define F7_MASK ((uint64_t)1<<F7)
#define G7 54
#define G7_MASK ((uint64_t)1<<G7)
#define H7 55
#define H7_MASK ((uint64_t)1<<H7)
#define A8 56
#define A8_MASK ((uint64_t)1<<A8)
#define B8 57
#define B8_MASK ((uint64_t)1<<B8)
#define C8 58
#define C8_MASK ((uint64_t)1<<C8)
#define D8 59
#define D8_MASK ((uint64_t)1<<D8)
#define E8 60
#define E8_MASK ((uint64_t)1<<E8)
#define F8 61
#define F8_MASK ((uint64_t)1<<F8)
#define G8 62
#define G8_MASK ((uint64_t)1<<G8)
#define H8 63
#define H8_MASK ((uint64_t)1<<H8)
#define EX 0xFF

#define BOARD_SQUARES   64

static const char *square_names_8x8[] = {
   "a1", "b1", "c1", "d1", "e1", "f1", "g1", "h1",
   "a2", "b2", "c2", "d2", "e2", "f2", "g2", "h2",
   "a3", "b3", "c3", "d3", "e3", "f3", "g3", "h3",
   "a4", "b4", "c4", "d4", "e4", "f4", "g4", "h4",
   "a5", "b5", "c5", "d5", "e5", "f5", "g5", "h5",
   "a6", "b6", "c6", "d6", "e6", "f6", "g6", "h6",
   "a7", "b7", "c7", "d7", "e7", "f7", "g7", "h7",
   "a8", "b8", "c8", "d8", "e8", "f8", "g8", "h8"
};

#endif
