/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "bitboard.h"

const bitboard_t square_bitboards[64] = {
   A1_MASK, B1_MASK, C1_MASK, D1_MASK, E1_MASK, F1_MASK, G1_MASK, H1_MASK,
   A2_MASK, B2_MASK, C2_MASK, D2_MASK, E2_MASK, F2_MASK, G2_MASK, H2_MASK,
   A3_MASK, B3_MASK, C3_MASK, D3_MASK, E3_MASK, F3_MASK, G3_MASK, H3_MASK,
   A4_MASK, B4_MASK, C4_MASK, D4_MASK, E4_MASK, F4_MASK, G4_MASK, H4_MASK,
   A5_MASK, B5_MASK, C5_MASK, D5_MASK, E5_MASK, F5_MASK, G5_MASK, H5_MASK,
   A6_MASK, B6_MASK, C6_MASK, D6_MASK, E6_MASK, F6_MASK, G6_MASK, H6_MASK,
   A7_MASK, B7_MASK, C7_MASK, D7_MASK, E7_MASK, F7_MASK, G7_MASK, H7_MASK,
   A8_MASK, B8_MASK, C8_MASK, D8_MASK, E8_MASK, F8_MASK, G8_MASK, H8_MASK
};

bitboard_t short_castle_mask[2] = { E1_MASK|H1_MASK,         E8_MASK|H8_MASK         };
bitboard_t short_castle_free[2] = { G1_MASK|F1_MASK,         G8_MASK|F8_MASK         };
bitboard_t short_castle_safe[2] = { G1_MASK|F1_MASK|E1_MASK, G8_MASK|F8_MASK|E8_MASK };
bitboard_t long_castle_mask[2]  = { E1_MASK|A1_MASK,         E8_MASK|A8_MASK         };
bitboard_t long_castle_free[2]  = { B1_MASK|C1_MASK|D1_MASK, B8_MASK|C8_MASK|D8_MASK };
bitboard_t long_castle_safe[2]  = { C1_MASK|D1_MASK|E1_MASK, C8_MASK|D8_MASK|E8_MASK };

/* Destination square for king on king-side and queen-side castling.
 * The rook moves to the left resp. right of the king.
 */
int8_t short_castle_king_dest[2] = { G1, G8 };
int8_t long_castle_king_dest[2]  = { C1, C8 };

static void print_uint8_t(uint8_t b)
{
   int c;
   
   for (c=0; c<8; c++) {
      printf ("%d", (b>>c)&1);
   }
}

/* This function prints a bitboard in such a way that 'A1' ends up on the
 * lower left corner and 'H8' ends up at the upper right corner.
 */
void printf_bitboard(bitboard_t b)
{
   int c;

   printf("+--------+\n");
   for (c=7; c>=0; c--) {
      printf("|");
      print_uint8_t(get_bitboard_row(b, c));
      printf("|\n");
   }
   printf("+--------+\n");
}

void print_bitboard_squares(bitboard_t b)
{
   int square;

   //printf("Bitboard squares: ");
   while(b) {
      square = bitscan64(b);
      b ^= make_bitboard_square(square);
      printf("%c%c ", unpack_file(square)+'a', unpack_rank(square)+'1');
   }
   //printf("\n");
}


