/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <ctype.h>
#include "board.h"
#include "pieces.h"

void clear_board(board_t *board)
{
   memset(board, 0, sizeof *board);
}



/**********************************************************************
 *                       output functions                             *
 **********************************************************************/
static const char out_char[] = { '.', '1' };
void print_uint8(uint8_t b)
{
   int c;

   for (c=0; c<8; c++) {
      printf ("%c", out_char[(b>>c)&1]);
   }
}

void print_bitboards(const board_t *board)
{
   int c, n;

   if (board->side_to_move == WHITE)
      printf("White to move\n");
   else
      printf("Black to move\n");

   printf("White pieces\tBlack pieces\tUnmoved pieces\tRoyal\t\tep\n");
   bitboard_t ep = board_empty;
   if (board->ep) ep = make_bitboard_square(board->ep);
   for (c=7; c>=0; c--) {
      print_uint8(get_bitboard_row(board->bbc[0], c));
      printf("\t");
      print_uint8(get_bitboard_row(board->bbc[1], c));
      printf("\t");
      print_uint8(get_bitboard_row(board->init, c));
      printf("\t");
      print_uint8(get_bitboard_row(get_royal(board), c));
      printf("\t");
      print_uint8(get_bitboard_row(ep, c));
      printf("\n");
   }

   for (n=0; n<NUM_PIECES; n+=6) {
      printf("\n");
      int k;
      for (k=0; k<6; k++) {
         if (n+k >= NUM_PIECES) break;
         const char *s = piece_name[n+k];
         printf("%-10s", s);
      }
      printf("\n");
      for (c=7; c>=0; c--) {
         for (k=0; k<6; k++) {
            if (n+k >= NUM_PIECES) break;
            print_uint8(get_bitboard_row(board->bbp[n+k], c));
            printf("  ");
         }
         printf("\n");
      }
   }

   if (board->holdings[0] || board->holdings[0]) {
      printf("[");
      for (n=0; n<NUM_PIECES; n++)
         if (board->holdings[0] & (1<<n)) printf("%c", white_piece_string[n]);
      for (n=0; n<NUM_PIECES; n++)
         if (board->holdings[1] & (1<<n)) printf("%c", black_piece_string[n]);
      printf("]\n");
   }
}

void print_board(const board_t *board)
{
   bitboard_t unocc = ~(board->bbc[WHITE] | board->bbc[BLACK]);
   int c, n;

#if 0
   for (c=large_board_ranks-1; c>=0; c--) {
      for (n=0; n<large_board_files; n++) {
         int square = pack_row_file(c, n);
         int piece = get_piece(board, square);
         if (make_bitboard_square(square) & unocc) {
            if ( (c^n)&1 )
               printf(". ");
            else
               printf("+ ");
         } else {
            char cc = board->piece_types->piece_abbreviation[piece][0];
            bool white = true;
            if (cc == ',') cc = board->piece_types->piece_abbreviation[piece][1];
            if (board->large_board) {
               white = !is_zero128(board->large_bbc[WHITE] & large_square_bitboards[pack_row_file(c, n)]);
            } else {
               white = board->bbc[WHITE] & make_bitboard_square(pack_row_file(c, n));
            }
            if (white) {
               cc = toupper(cc);
            } else {
               cc = tolower(cc);
            }
            printf("%c ", cc);
         }
      }
      printf("\n");
   }
#endif
}

