/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "square.h"

int diagonal_a8h1_diagonal[64];
int diagonal_a1h8_diagonal[64];

char *square_names[64];

void construct_inverse_diagonal_maps(void)
{
   int n;

   for (n=0; n<64; n++) {
      diagonal_a8h1_diagonal[n] = calculate_a8h1_diagonal(n);
      diagonal_a1h8_diagonal[n] = calculate_a1h8_diagonal(n);
   }
}

void load_square_names(int files, int ranks)
{
   int n;
   int f, r;

   for (n=0; n<128; n++)
      free(square_names[n]);
   memset(square_names, 0, sizeof square_names);

   for (f=0; f<files; f++) {
      for (r=0; r<ranks; r++) {
         n = f + r*files;
         square_names[n] = malloc(10);
         snprintf(square_names[n], 10, "%c%d", f+'a', r+1);
      }
   }
}
