/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "pieces.h"

uint16_t promotion_options[NUM_SIDES] = {
   1<<KNIGHT | 1<<BISHOP | 1<<ROOK | 1<<QUEEN,
   1<<LIEUTENANT | 1<<CAPTAIN | 1<<GENERAL | 1<<WARLORD | 1<<BASILEUS
};

const char *white_piece_string = "PNBRQKHLCGWKM";
const char *black_piece_string = "pnbrqkhlcgwkm";
const char *piece_symbol_string = " NBRQK LCGWKM";
const char *piece_name[] = {
   "Pawn", "Knight", "Bishop", "Rook", "Queen", "King",
   "Hoplite", "Lieutenant", "Captain", "General", "Warlord", "King",
   "R+N"
};

