/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef BITS64_H
#define BITS64_H

#include <stdbool.h>
#include <stdint.h>
#include "assert.h"

static inline bool onebit64(uint64_t x)
{
   return (x & (x-1)) == 0;
}

static inline int bitscan64(uint64_t x) {
   assert(x);
#ifdef __GNUC__
   return __builtin_ctzll (x);
#else
   int i = 0;
   for (x=x<<1; x; x=x<<1)
      i++;
   return i;
#endif
}

static inline uint64_t sshift64(uint64_t x, int s)
{
   signed char left  =   (signed char) s;
   signed char right = -((signed char)(s >> 8) & left);
   return (x >> right) << (right + left);
}


static inline int bitscan16(uint16_t x) {
   assert(x);
#ifdef __GNUC__
   return __builtin_ctz (x);
#else
   int i = 0;
   for (x=x<<1; x; x=x<<1)
      i++;
   return i;
#endif
}

/* Return the number of bits set on a bitboard
 * From http://chessprogramming.wikispaces.com/Population+Count
 */
static inline int popcount64(uint64_t x)
{
#ifdef __GNUC__
    return __builtin_popcountll(x);
#else
    const uint64_t k1 = 0x5555555555555555ll;
    const uint64_t k2 = 0x3333333333333333ll;
    const uint64_t k4 = 0x0f0f0f0f0f0f0f0fll;
    const uint64_t kf = 0x0101010101010101ll;
    x =  x       - ((x >> 1)  & k1);
    x = (x & k2) + ((x >> 2)  & k2);
    x = (x       +  (x >> 4)) & k4;
    x = (x * kf) >> 56;
    return (int) x;
#endif
}
#endif
