/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef LEONIDAS_H
#define LEONIDAS_H

#include "board.h"
#include "movegen.h"
#include "game.h"
#include "timer.h"
#include "genrand.h"
#include "hashtable.h"
#include "evaluate.h"
#include "play.h"
#include "search.h"
#include "variants.h"

static void initialise_leonidas(void)
{
   initialise_movement_tables(NORMAL_PAWN, SPARTAN_PAWN);
   load_square_names(8, 8);
   initialise_evaluation();
   initialise_hash_keys();
   playgame_init();
}

#endif
