/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <ctype.h>
#include "leonidas.h"

game_t *create_standard_game(void)
{
   game_t *game = create_game();

   /* Initialise the movement tables */
   initialise_movement_tables(NORMAL_PAWN, NORMAL_PAWN);
   initialise_evaluation();

   /* Set the FEN string for the starting position */
   game->start_fen = strdup("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq -");
   game->name = strdup("Chess");

   white_piece_string = "PNBRQK       ";
   black_piece_string = " nbrqkp      ";

   promotion_options[WHITE] = 1<<KNIGHT | 1<<BISHOP | 1<<ROOK | 1<<QUEEN;
   promotion_options[BLACK] = 1<<KNIGHT | 1<<BISHOP | 1<<ROOK | 1<<QUEEN;

   assert(strlen(white_piece_string) == NUM_PIECES);
   assert(strlen(black_piece_string) == NUM_PIECES);

   return game;
}


game_t *create_seirawan_game(void)
{
   game_t *game = create_game();

   /* Initialise the movement tables */
   initialise_movement_tables(NORMAL_PAWN, NORMAL_PAWN);
   initialise_evaluation();

   /* Set the FEN string for the starting position */
   game->start_fen = strdup("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR [HEhe] w KQkq -");
   game->name = strdup("Seirawan chess");

   white_piece_string = "PNBRQK    H E";
   black_piece_string = " nbrqkp   h e";
   piece_symbol_string = " NBRQK LCGHKE";
   piece_name[HAWK] = "Hawk";
   piece_name[ELEPHANT] = "Elephant";

   promotion_options[WHITE] = 1<<KNIGHT | 1<<BISHOP | 1<<ROOK | 1<<QUEEN | 1<<HAWK | 1<<ELEPHANT;
   promotion_options[BLACK] = 1<<KNIGHT | 1<<BISHOP | 1<<ROOK | 1<<QUEEN | 1<<HAWK | 1<<ELEPHANT;

   assert(strlen(white_piece_string) == NUM_PIECES);
   assert(strlen(black_piece_string) == NUM_PIECES);

   return game;
}

game_t *create_berolina_game(void)
{
   game_t *game = create_game();

   /* Initialise the movement tables */
   initialise_movement_tables(BEROLINA_PAWN, BEROLINA_PAWN);
   initialise_evaluation();

   /* Set the FEN string for the starting position */
   game->start_fen = strdup("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq -");
   game->name = strdup("Berolina chess");

   white_piece_string = "PNBRQK       ";
   black_piece_string = " nbrqkp      ";

   promotion_options[WHITE] = 1<<KNIGHT | 1<<BISHOP | 1<<ROOK | 1<<QUEEN;
   promotion_options[BLACK] = 1<<KNIGHT | 1<<BISHOP | 1<<ROOK | 1<<QUEEN;

   assert(strlen(white_piece_string) == NUM_PIECES);
   assert(strlen(black_piece_string) == NUM_PIECES);

   return game;
}

game_t *create_spartan_game(void)
{
   game_t *game = create_game();

   /* Initialise the movement tables */
   initialise_movement_tables(NORMAL_PAWN, SPARTAN_PAWN);
   initialise_evaluation();

   /* Set the FEN string for the starting position */
   game->start_fen = strdup("lgkcckwl/hhhhhhhh/8/8/8/8/PPPPPPPP/RNBQKBNR w KQ -");
   game->name = strdup("Spartan chess");

   white_piece_string = "PNBRQK       ";
   black_piece_string = "      hlcgwk ";

   promotion_options[WHITE] = 1<<KNIGHT | 1<<BISHOP | 1<<ROOK | 1<<QUEEN;
   promotion_options[BLACK] = 1<<LIEUTENANT | 1<<CAPTAIN | 1<<GENERAL | 1<<WARLORD | 1<<BASILEUS;

   assert(strlen(white_piece_string) == NUM_PIECES);
   assert(strlen(black_piece_string) == NUM_PIECES);

   return game;
}

