/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef ALPHABETA_H
#define ALPHABETA_H

#include "game.h"

extern volatile bool abort_search;
extern size_t positions_evaluated;
extern size_t moves_searched;
extern int positions_in_hashtable;
extern int branches_pruned;

int count_repetition(const game_t *game);
bool is_mate(game_t *game);
bool game_ended(game_t *game);
bool game_is_draw(game_t *game);
sides get_winner(game_t *game);
int search(game_t *game, int alpha, int beta, int draft, int depth);
#endif
