/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef EVAL_TABLE_H
#define EVAL_TABLE_H

typedef struct {
   uint64_t key;           /* Store the full key (for position verification) */
   int score;              /* The value of this node */
   int generation;         /* The age of this entry */
} eval_table_entry_t;

typedef struct {
   eval_table_entry_t *data;
   size_t number_of_elements;
   size_t write_count;
   uint8_t generation;
} eval_hash_table_t;

eval_hash_table_t *create_eval_hash_table(size_t nelem);
void destroy_eval_hash_table(eval_hash_table_t *table);
eval_table_entry_t *query_eval_table_entry(eval_hash_table_t *table, uint64_t key);
void store_eval_table_entry(eval_hash_table_t *table, uint64_t key, int score);
void prepare_evaltable_search(eval_hash_table_t *table);
void prefetch_evaltable(eval_hash_table_t *table, uint64_t key);

#endif

