/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef MOVE_BITBOARD_H
#define MOVE_BITBOARD_H

#include "bitboard.h"
#include "move.h"

/* Get a bitboard of all squares affected by a move */
static inline large_bitboard_t get_move_large_mask(move_t move)
{
   large_bitboard_t bb = large_board_empty;
   int n, c;

    /* First: mark all pickups */
    n = get_move_pickups(move);
    for (c=0; c<n; c++) {
       uint16_t p = get_move_pickup(move, c);
       int square = decode_pickup_square(p);

       bb |= large_square_bitboards[square];
    }

    /* Second: mark all drops */
    n = get_move_drops(move);
    for (c=0; c<n; c++) {
       uint16_t p = get_move_drop(move, c);
       int square = decode_drop_square(p);

       bb |= large_square_bitboards[square];
    }

   return bb;
}

static inline bitboard_t get_move_mask(move_t move)
{
   bitboard_t bb = board_empty;
   int n, c;

    /* First: mark all pickups */
    n = get_move_pickups(move);
    for (c=0; c<n; c++) {
       uint16_t p = get_move_pickup(move, c);
       int square = decode_pickup_square(p);

       bb |= make_bitboard_square(square);
    }

    /* Second: mark all drops */
    n = get_move_drops(move);
    for (c=0; c<n; c++) {
       uint16_t p = get_move_drop(move, c);
       int square = decode_drop_square(p);

       bb |= make_bitboard_square(square);
    }

   return bb;
}

#endif
