/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef MOVEFLAGS_H
#define MOVEFLAGS_H

#define MF_SLIDER_H     0x00000001
#define MF_SLIDER_V     0x00000002
#define MF_SLIDER_D     0x00000004
#define MF_SLIDER_A     0x00000008
#define MF_SLIDER       0x0000000F

#define MF_HOPPER_H     0x00000010
#define MF_HOPPER_V     0x00000020
#define MF_HOPPER_D     0x00000040
#define MF_HOPPER_A     0x00000080
#define MF_HOPPER       0x000000F0

#define MF_HOPSLIDE     (MF_HOPPER | MF_SLIDER)

#define MF_STEPPER      0x00000F00  /* This is an index in an array with repeat counts */

#define MF_LEAPER       0x000F0000  /* This is an index in an array */
#define MF_LEAPER2      0x00F00000  /* Second index, for compound leapers */
#define MF_LEAPER_MASK  0x0F000000  /* Mask index, for compound leapers */
#define MF_IS_LEAPER    0x10000000  /* Whether this is actually a leaper */
#define MF_LEAPER_HAVE2 0x20000000  /* Leaper is a compound leaper */
#define MF_LEAPER_HAVEM 0x40000000  /* Leaper has a mask (only makes sense for compound leapers) */
#define MF_LEAPER_ASYMM 0x80000000  /* Leaper is asymmetric */
#define MF_LEAPER_FLAGS 0xFFFF0000  /* All leaper flags */

#define MF_HOPSLIDELEAP (MF_HOPSLIDE | MF_IS_LEAPER)

/* Stepper repeat count masks (3 bits per direction) */
#define MF_STEPPER_N    (7 << 0)
#define MF_STEPPER_NE   (7 << 3)
#define MF_STEPPER_E    (7 << 6)
#define MF_STEPPER_SE   (7 << 9)
#define MF_STEPPER_S    (7 << 12)
#define MF_STEPPER_SW   (7 << 15)
#define MF_STEPPER_W    (7 << 18)
#define MF_STEPPER_NW   (7 << 21)

#endif
