/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef PAWN_TABLE_H
#define PAWN_TABLE_H

typedef struct {
   uint64_t key;           /* Store the full key (for position verification) */
   int score;              /* The value of this node */
   int generation;         /* The age of this entry */
} pawn_table_entry_t;

typedef struct {
   pawn_table_entry_t *data;
   size_t number_of_elements;
   size_t write_count;
   uint8_t generation;
} pawn_hash_table_t;

pawn_hash_table_t *create_pawn_hash_table(size_t nelem);
void destroy_pawn_hash_table(pawn_hash_table_t *table);
pawn_table_entry_t *query_pawn_table_entry(pawn_hash_table_t *table, uint64_t key);
void store_pawn_table_entry(pawn_hash_table_t *table, uint64_t key, int score);
void prepare_pawntable_search(pawn_hash_table_t *table);
void prefetch_pawntable(pawn_hash_table_t *table, uint64_t key);

#endif

