/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef SQUARE_H
#define SQUARE_H

#include <stdint.h>

/* Map squares from the rotated bitboard back to the normal board. */
/* FIXME: these are now redundant! */
extern int diagonal_a8h1_diagonal[64];
extern int diagonal_a1h8_diagonal[64];

extern uint8_t large_diagonal_nr[128];
extern uint8_t large_anti_diagonal_nr[128];

extern int large_board_files;
extern int large_board_ranks;

extern uint8_t packed_file_rank[128];

extern char *square_names[128];
extern char *kingside_castle;
extern char *queenside_castle;

void construct_inverse_diagonal_maps(void);
void load_square_names(int files, int ranks);

/********************************************************************
 * Functions for dealing with packing/unpacking square rows/files *
 ********************************************************************/
static inline int pack_row_file(int row, int file)
{
   return file + (row * large_board_files);
}

static inline int unpack_rank(int packed)
{
   return packed_file_rank[packed] >> 4;
}

static inline int unpack_file(int packed)
{
   return packed_file_rank[packed] & 0xf;
}

static inline int flip_horizontal(int packed)
{
   int file = packed & 7;
   return (packed & ~7) | (7 - file);
}


/********************************************************************
 * Functions for mapping squares onto a rotated bitboard (a8-h1)    * 
 ********************************************************************/
/* returns the number of the diagonal parallel to a8-h1 that the square is
 * on. Used for rotated bitboards.
 */
static inline int calculate_a8h1_diagonal(int packed)
{
   return unpack_rank(packed)+unpack_file(packed);
}

/* returns the number of the diagonal parallel to a8-h1 that the square is
 * on. Used for rotated bitboards.
 */
static inline int get_a8h1_diagonal(int packed)
{
   return unpack_rank(packed)+unpack_file(packed);
   //return diagonal_a8h1_diagonal[packed];
}


/********************************************************************
 * Functions for mapping squares onto a rotated bitboard (a1-h8)    * 
 ********************************************************************/
/* returns the number of the diagonal parallel to a1-h8 that the square is
 * on. Used for rotated bitboards.
 */
static inline int calculate_a1h8_diagonal(int packed)
{
   return unpack_rank(packed)+7-unpack_file(packed);
}

/* returns the number of the diagonal parallel to a1-h8 that the square is
 * on. Used for rotated bitboards.
 */
static inline int get_a1h8_diagonal(int packed)
{
   return unpack_rank(packed)+7-unpack_file(packed);
   //return diagonal_a1h8_diagonal[packed];
}

#endif
