/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef VARIANTS_H
#define VARIANTS_H

#include "game.h"

extern game_t *create_standard_game(void);
extern game_t *create_berolina_game(void);
extern game_t *create_pocketknight_game(void);
extern game_t *create_chinese_game(void);
extern game_t *create_amazon_game(void);
extern game_t *create_spartan_game(void);
extern game_t *create_maharaja_game(void);
extern game_t *create_knightmate_game(void);
extern game_t *create_losers_game(void);
extern game_t *create_shatranj_game(void);
extern game_t *create_xboard_shatranj_game(void);
extern game_t *create_makruk_game(void);
extern game_t *create_burmese_game(void);

extern game_t *create_capablanca_game(void);
extern game_t *create_gothic_game(void);
extern game_t *create_embassy_game(void);
extern game_t *create_janus_game(void);

extern game_t *create_grand_game(void);
extern game_t *create_indiangrand_game(void);

extern game_t *create_courier_game(void);

extern game_t *create_game_from_file(const char *filename, const char *variant_name);

typedef game_t *(*new_variant_game_t)(void);

extern new_variant_game_t create_variant_from_name(const char * const name);
#endif
