/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>

#include "sjaak.h"

int main(void)
{
   game_t *game;

   construct_inverse_diagonal_maps();
   initialise_slider_tables();
   initialise_hash_keys();
   playgame_init();

   game = create_capablanca_game();

   uint64_t *u;
#if 0
   int n=0;
   if (0)for (n=0; n<128; n++) {
      u = (uint64_t *)&large_square_bitboards[n];

      printf("0x%016llx%016llx\n", u[1], u[0]);
   }
   large_bitboard_t bb = shr128(large_square_bitboards[70], 0);
   u = (uint64_t *)&bb;
   printf("0x%016llx%016llx\n", u[1], u[0]);
   exit(0);
   u = (uint64_t *)&bb;
   printf_large_bitboard(bb);
   printf("0x%016llx%016llx\n", u[1], u[0]);
   exit(0);
   u = (uint64_t *)&large_board_all;
   printf("\n0x%016llx %016llx\n", u[1], u[0]);
   u = (uint64_t *)&large_board_empty;
   printf("0x%016llx %016llx\n", u[1], u[0]);
   u = (uint64_t *)&large_board_edge;
   printf("0x%016llx %016llx\n", u[1], u[0]);
#endif

   printf_large_bitboard(large_board_diagonal[0]);
   printf_large_bitboard(large_board_diagonal[6]);
   printf_large_bitboard(large_board_antidiagonal[0]);
   printf_large_bitboard(large_board_antidiagonal[7]);

   //__uint128_t x, y;
   uint128_t xx, yy;

   xx = large_board_antidiagonal[7];
   yy = large_board_west_edge;

   void *p = &xx;
   u = (uint64_t *)p;
   p = &yy;
   u = (uint64_t *)p;

   xx = mul128(xx, yy);
   printf_large_bitboard(xx);

   /* Print information about all piece types. */
   print_piece_types(game);
   get_mobility_statistics(game);

   start_new_game(game);

   print_bitboards(&game->board);

#if 0
   uint16_t occ = (1<<4) | (1<<6) | (1<<8) | (1<<9);
   uint8_t vocc = (1<<4) | (1<<6);
   int n;
   printf_large_bitboard(large_vmslider[6][vocc]);
   for (n=0; n<large_board_ranks; n++)
      printf("%d\n", (vocc >> (large_board_ranks-1-n)) & 1);
   printf_large_bitboard(large_hmslider[6][occ]);
   printf(" ");
   for (n=0; n<large_board_files; n++) {
      printf("%d", (occ >> n) & 1);
   }
   printf("\n");
#endif

   movelist_t movelist;
   generate_moves(&movelist, &game->board, WHITE);
   move_t move = movelist.move[0];
   printf("%s\n", move_string(move, NULL));
   playmove(game, move);

   setup_fen_position(game, "rnabqkbcnr/pppppppppp/10/10/10/7n2/PPPPPPPPPP/R4K3R w KQkq -");
   //setup_fen_position(game, "rn1bqkbcnr/p1pppppppp/ap8/10/10/PP8/2PPPPPPPP/RNABQKBCNR w KQkq -");
   //setup_fen_position(game, "rn1bqkbcnr/p1pppppppp/ap8/10/10/PP2P5/2PP1PPPPP/RNABQKBCNR b KQkq -");
   setup_fen_position(game, "2rb6/p1p2r2kp/1p1p1p2p1/5Cp1N1/4P5/2PPK2R1P/1q5PP1/5R4 b - - 1 37");
   setup_fen_position(game, "r4kb2r/ppp1bppp1p/3a1n1np1/10/10/2A2P1N2/PP1PP1PP1P/RNqBQKB1R1 b Qkq - 8 13");
   setup_fen_position(game, "5kb3/pp3p1p1p/3p2p3/5n4/5A4/2P3PP2/P2p6/K9 b - - 73 37");
   print_bitboards(&game->board);
   generate_moves(&movelist, &game->board, game->board.side_to_move);
   int n;
   printf("%d moves\n", movelist.num_moves);
   for (n=0; n<movelist.num_moves; n++) {
      printf("%s ", move_string(movelist.move[n], NULL));
   }
   printf("\n");

   //large_bitboard_t occ = game->board.large_bbc[0];
   //printf_large_bitboard(large_board_antidiagonal[large_anti_diagonal_nr[50]]);
   //printf_large_bitboard(occ);
   //printf_large_bitboard(get_large_antidiagonal_attacks(large_hcslider, occ, 50));
   //printf_large_bitboard(large_hcslider[0][32]);
   //printf("%d\n", player_in_check(game, WHITE));
#if 0
   int r, f;
   for (r=large_board_ranks-1; r>=0; r--) {
      for (f = 0; f< large_board_files; f++) {
         n = f + r * large_board_files;

         printf("%3d ", large_diagonal_nr[n]);
      }
      printf("\n");
   }
#endif

   exit(0);

   /* Start a new game */
   start_new_game(game);
   setup_fen_position(game, "8/p1P1k3/6p1/1P1p4/P4pP1/2P2KP1/5P2/4r3/ b KQkq -");
   setup_fen_position(game, "5Kbk/6pp/6P1/8/8/7R/8/8 w - -");
   setup_fen_position(game, "r1b2k1r/p4pbp/nq1p1Q2/2pP4/1p2R2N/6P1/P3PPBP/4K2R/ w - -"); // Mate in 9
   //setup_fen_position(game, "r1b2rk1/ppp1p1bp/2n2pp1/3qP3/3P4/2PB1N2/PP4PP/R1BQK2R w KQ - ");
   //setup_fen_position(game, "r1bk2nr/pp1pnBp1/3B3p/5pP1/2PN3P/1P2R3/P4P2/R3K3 b Q - 5 26");
   //setup_fen_position(game, "r1b1r1k1/6b1/pQ4pp/4Np2/5P1q/6P1/PPp4P/RNB1R1K1 b - - 0 22");
   //setup_fen_position(game, "r3k2r/8/8/8/8/8/8/R3K2R/ b KQkq -");

   /* Show position */
   print_bitboards(&game->board);

   //movelist_t movelist;
   //generate_moves(&movelist, &game->board, BLACK);
   generate_moves(&movelist, &game->board, WHITE);

   computer_play(game, 15);

   end_game(game);

   return 0;
}
