/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdlib.h>
#include "eval_params.h"

eval_param_t eval_param[] = {
   /* Name                       Type                 ptr         mul      div      min      max */
   { "king safety ceil",         EVAL_PARAM_FLOAT,    NULL,       1,         10,    0,       10000 },
   { "king safety slope",        EVAL_PARAM_FLOAT,    NULL,       1,       1000,    0,       10000 },
   { "king safety inflextion",   EVAL_PARAM_FLOAT,    NULL,       1,         10,    0,         100 },
#define KING_SAFETY_CEIL         262.5       /* Asymptotic value */
#define KING_SAFETY_SLOPE          0.15      /* Slope of the king safety evaluation term */
#define KING_SAFETY_INFLECTION    18         /* Inflection point where the evaluation begins to rise steeply */
   { NULL, 0, NULL, 1, 1, 1, 1 }
};

