/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include "square.h"

int diagonal_a8h1_diagonal[64];
int diagonal_a1h8_diagonal[64];

static bool virgin = true;
char *square_names[128] = { NULL };

char *kingside_castle = NULL;
char *queenside_castle = NULL;

/* Store file/rank for each square, use one nibble for each.
 * We do this rather than calculating modulus/divisions on each access, since that can
 * become quite expensive.
 */
uint8_t packed_file_rank[128];

/* Diagonal/anti-diagonal ordinance numbers */
uint8_t large_diagonal_nr[128];
uint8_t large_anti_diagonal_nr[128];

int large_board_files;
int large_board_ranks;

void construct_inverse_diagonal_maps(void)
{
   int n;

   for (n=0; n<64; n++) {
      diagonal_a8h1_diagonal[n] = calculate_a8h1_diagonal(n);
      diagonal_a1h8_diagonal[n] = calculate_a1h8_diagonal(n);
   }
}

void load_square_names(int files, int ranks)
{
   int n;
   int f, r;

   for (n=0; n<128; n++) {
      if (!virgin) free(square_names[n]);
      square_names[n] = NULL;
   }
   virgin = false;

   for (f=0; f<files; f++) {
      for (r=0; r<ranks; r++) {
         n = f + r*files;
         square_names[n] = malloc(10);
         snprintf(square_names[n], 10, "%c%d", f+'a', r+1);

         packed_file_rank[n] = f | (r << 4);
      }
   }

   /* Set up diagonals and anti-diagonals
    * For the mapping of diagonal numbers, we pretend the board is square; it may not be, but this is easiest.
    */
   int s = files;
   if (ranks > files) s = ranks;
   for (n = 0; n<files*ranks; n++) {
      int f = n % files;
      int r = n / files;
      large_diagonal_nr[n] = r + (s-1) - f;
      large_anti_diagonal_nr[n] = r + f;
   }

   /* Castling notation */
   kingside_castle  = "O-O";
   queenside_castle = "O-O-O";
}
