/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>

#include "sjaak.h"

#define streq(s1, s2) (strcmp((s1), (s2)) == 0)

static game_t *(*new_variant_game)(void) = create_standard_game;

int main(int argc, char **argv)
{
   movelist_t movelist;
   int depth = 12;
   game_t *game;

   construct_inverse_diagonal_maps();
   initialise_slider_tables();
   initialise_hash_keys();
   playgame_init();

   new_variant_game = create_standard_game;

   if (argc>1) {
      int n;
      for (n=1; n<argc; n++) {
         if (strstr(argv[n], "-variant")) {
            if (n+1 >= argc) {
               fprintf(stderr, "error: -variant passed, but no variant specified");
               exit(0);
            }
            n++;

            char *input = argv[n];
            new_variant_game = create_variant_from_name(input);
            if (new_variant_game == NULL) {
               fprintf(stderr, "error: variant '%s' unknown\n", input);
               exit(0);
            }
            if (game) {
               end_game(game);
            }
            game = new_variant_game();

            /* Print information about all piece types. */
            print_piece_types(game);
         } else if (strstr(argv[n], ".epd")) {
            char fen[4096];
            FILE *f;

            if (!game) {
               game = new_variant_game();

               /* Print information about all piece types. */
               print_piece_types(game);
            }

            f = fopen(argv[n], "r");
            fgets(fen, sizeof fen, f);
            fclose(f);

            start_new_game(game);
            setup_fen_position(game, fen);

            generate_moves(&movelist, &game->board, game->board.side_to_move);
            print_bitboards(&game->board);

            computer_play(game, depth);
         } else {
            int new_depth, result;
            
            result = sscanf(argv[n], "%d", &new_depth);
            if (result == 1)
               depth = new_depth;
         }
      }
      exit(0);
   }

   /* Start a new game */
   game = create_standard_game();
   start_new_game(game);
   setup_fen_position(game, "8/p1P1k3/6p1/1P1p4/P4pP1/2P2KP1/5P2/4r3/ b KQkq -");
   setup_fen_position(game, "5Kbk/6pp/6P1/8/8/7R/8/8 w - -");
   setup_fen_position(game, "r1b2k1r/p4pbp/nq1p1Q2/2pP4/1p2R2N/6P1/P3PPBP/4K2R/ w - -"); // Mate in 9
   //setup_fen_position(game, "r1b2rk1/ppp1p1bp/2n2pp1/3qP3/3P4/2PB1N2/PP4PP/R1BQK2R w KQ - ");
   //setup_fen_position(game, "r1bk2nr/pp1pnBp1/3B3p/5pP1/2PN3P/1P2R3/P4P2/R3K3 b Q - 5 26");
   //setup_fen_position(game, "r1b1r1k1/6b1/pQ4pp/4Np2/5P1q/6P1/PPp4P/RNB1R1K1 b - - 0 22");
   //setup_fen_position(game, "r3k2r/8/8/8/8/8/8/R3K2R/ b KQkq -");

   /* Show position */
   print_bitboards(&game->board);
   get_mobility_statistics(game);

   //generate_moves(&movelist, &game->board, BLACK);
   generate_moves(&movelist, &game->board, WHITE);

   computer_play(game, 15);

   end_game(game);

   return 0;
}
