/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>

#include "sjaak.h"

uint64_t perft(game_t *game, int depth, bool root)
{
   movelist_t movelist;
   sides me = game->board.side_to_move;
   uint64_t nodes = 0;
   int n;

   if (depth == 0) return 1;

   /* Check if previous move left the player in check */
   generate_moves(&movelist, &game->board, me);

   for (n=0; n<movelist.num_moves; n++) {
      uint64_t count = 0;
      playmove(game, movelist.move[n]);
      if (!player_in_check(game, me))  /* Don't count illegal moves */
         count = perft(game, depth-1, false);
      nodes += count;
      if (root)
         printf("%8s %10lld %10lld\n", move_string(movelist.move[n], NULL), count, nodes);
      takeback(game);
   }
   return nodes;
}


int main(void)
{
   game_t *game;

   construct_inverse_diagonal_maps();
   initialise_slider_tables();
   initialise_hash_keys();

   playgame_init();

   game = create_spartan_game();

   /* Start a new game */
   start_new_game(game);
   //setup_fen_position(game, "lgkcckwl/hhhh1hhh/3h4/8/3PP3/8/PPP2PPP/RNBQKBNR/ b KQ -");
   //setup_fen_position(game, "2k2k2/7Q/3K4/8/8/8/R7/8 w - - 0 1");

   /* Show position */
   print_bitboards(&game->board);

   /* Perft timing */
   uint64_t t;
   int n;
   t = get_timer();
   for (n = 1; n<7; n++) {
      uint64_t nodes = perft(game, n, false);
      uint64_t tt = get_timer();

      if (tt == t) tt++;

      printf("%2d %10lld %5.2f %12.2fnps\n", n, nodes,
         (tt - t)/1000000.0,nodes*1.0e6/(tt-t));

      t = tt;
   }


   end_game(game);

   return 0;
}
