/*  Sjaak, a program for playing chess variants
 *  Copyright (C) 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>
#include <time.h>

#include "sjaak.h"

int main(void)
{
   game_t *game;

   construct_inverse_diagonal_maps();
   initialise_slider_tables();
   initialise_hash_keys();

   playgame_init();

   game = create_spartan_game();

   /* Print information about all piece types. */
   print_piece_types(game);

   /* Start a new game */
   start_new_game(game);
   //setup_fen_position(game, "8/8/8/8/8/k7/5h2/K7/ b - -");
   //setup_fen_position(game, "R7/2hk1P2/8/2w5/8/6P1/h3h2P/1B3K2 b - - 2 59");
   //setup_fen_position(game, "8/8/Bk6/8/1l1h4/1PR2P1P/hg6/4K3 b - - 0 66");

   /* Initialise random number generator.
    * We add a random number to the move score at the root for the first few plies, so we don't play the same
    * game all the time.
    */
   sgenrand(time(NULL));

   /* Show position */
   print_bitboards(&game->board);

   int n;
   set_time_per_move(game, 1000);
   for (n=0; n<100; n++)
      if (!computer_play(game, 30))
         break;
   print_bitboards(&game->board);

   end_game(game);

   return 0;
}
