#include <stdio.h>
#include "movegen.h"
#include "moveflags.h"

static void print_uint8_t(uint8_t b)
{
   int c;
   
   for (c=0; c<8; c++) {
      printf ("%d", (b>>c)&1);
   }
}

int main(void)
{
   construct_inverse_diagonal_maps();
   initialise_slider_tables();

   int index = define_leaper("leap (1,0)+(1,1)&(2,1)");
   //index = define_leaper("leap (1,0)|(1,1)");
   printf("%08x (%d)\n", index&MF_LEAPER, index & MF_IS_LEAPER);
   printf("%08x (%d)\n", index&MF_LEAPER2, index & MF_LEAPER_HAVE2);
   printf("%08x (%d)\n", index&MF_LEAPER_MASK, index & MF_LEAPER_HAVEM);
   printf("%02x\n", leaper_description[0]);
   printf("%02x\n", leaper_description[1]);
   printf("%02x\n", leaper_description[2]);
   printf("%02x\n", leaper_description[3]);

   index = define_slider("hop (H,V) slide (D,A)");
   printf("%08x\n", index);

   return 0;

   uint8_t occ = 0xdb;
   int rank = 3, file = 1;
   uint64_t bb;

   printf("\n");
   printf("%d %d\n", rank, file);
   print_uint8_t(occ); printf("\n");
   bb = make_bitboard_file(occ, file);
   printf_bitboard(bb);
   bb = get_file_attacks(hcslider, bb, pack_row_file(rank,file));
   printf_bitboard(bb);

   printf("\n");
   printf("%d %d\n", rank, file);
   print_uint8_t(occ); printf("\n");
   bb = make_bitboard_row(occ, rank);
   printf_bitboard(bb);
   bb = get_rank_attacks(hcslider, bb, pack_row_file(rank,file));
   printf_bitboard(bb);

   printf("\n");
   printf("%d %d\n", rank, file);
   print_uint8_t(occ); printf("\n");
   bb = make_bitboard_a1h8_diagonal(occ, pack_row_file(rank,file));
   printf_bitboard(bb);
   bb = get_diagonal_attacks(hcslider, bb, pack_row_file(rank,file));
   printf_bitboard(bb);

   printf("\n");
   printf("%d %d\n", rank, file);
   print_uint8_t(occ); printf("\n");
   bb = make_bitboard_a8h1_diagonal(occ, pack_row_file(rank,file));
   printf_bitboard(bb);
   bb = get_antidiagonal_attacks(hcslider, bb, pack_row_file(rank,file));
   printf_bitboard(bb);

   /* Diagonal attacks */
   //bb *= board_afile;
   //printf_bitboard(board_a8h1_diagonal[7] & bb);
}

