#!/usr/bin/perl
use strict;

# Path to Sjef
my $sjef = "$ENV{'HOME'}/bin/sjef";

# Engine to tune
my $engine = "./engine";

# Command to send to engine to set a parameter value
my $set_parameter = "setvalue {name}={value}";

# Opponent engines in the gauntlet
my @opponents = (
   "/path/to/opponent1",
   "/path/to/opponent2",
);

# Variant to play
# One of "normal", "berolina", "pocketknight", "amazon", "spartan", "knightmate", "maharaja", "makruk", "burmese", "shatranj", "capablanca", "gothic", "janus", "courier", "xiangqi", "grand", "indiangrand"
my $variant = "normal";

# Time control, specified as moves/time+inc, with time in seconds (or min:sec) and inc in msec
my $tc = "40/0:05+0";

# Minimum time to give to an engine when it runs out of time; this is mainly useful for ultrashort games
my $tmin = "0";

# Options for Sjef; set additional options here
my $options = "-mg 1 -variant $variant -tc $tc -mtpm $tmin";

# Store a log from Sjef?
my $log = 0;


##########################################
# Now for the actual wrapper around Sjef #
##########################################


# Now parse commandline arguments
my $cpu_id = shift @ARGV;
my $seed = shift @ARGV;

# Store log?
if ($log) { $options .= " -log sjef_$seed.log"; }

# Who plays white?
my $black = $seed & 1;
$seed >>= 1;

# Select opponent, based on the list
my $nother = $#opponents + 1;
my $other = $opponents[0];
if ($nother > 1) {
   my $n = $seed % $nother;
   $seed /= $nother;
   $other = $opponents[$n];
}

# Determine whether the engine plays white or black
my $initstr = "-finit";
my $ecp = "-fcp";
my $ocp = "-scp";

# Flip colours
if ($black) {
   $initstr = "-sinit";
   $ecp = "-scp";
   $ocp = "-fcp";
}

while ($#ARGV > -1) {
   my $name = shift @ARGV;
   my $value = shift @ARGV;

   if (defined $name && defined $value) {
      my $s = $set_parameter;
      $s =~ s/{name}/$name/;
      $s =~ s/{value}/$value/;
      $options .= " $initstr '$s'";
   }
}

# Run the match
my $output = `$sjef $options $ecp $engine $ocp $other`;

# Parse results
my $result = -1;
if ($output =~ m/Game result: 1-0/) {
   $result = 0 + $black;
} elsif ($output =~ m/Game result: 0-1/) {
   $result = 1 - $black;
} elsif ($output =~ m/Game result: 1\/2-1\/2/) {
   $result = 2;
}

# Abort if an error occurred
die if ($result < 0);

# Write output to stdout
my @resstr = ( "W", "L", "D" );
print "$resstr[$result]\n";
