/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef BOOK_H
#define BOOK_H

#include <stdint.h>
#include "board.h"
#include "pg_book.h"

/* Jazz opening book.
 * This is a wrapper that could wrap a Polyglot, Rebel or custom format.
 */
typedef struct {
   uint32_t type;
   polyglot_book_t *pg;
} book_t;

#define BOOK_FLAGS_POLYGLOT   0x01

typedef polyglot_position_t opening_position_t;

/* Open a polyglot opening book */
book_t *open_opening_book(const char *filename);

/* Look up the current position in the opening book */
opening_position_t *get_book_move(book_t *book, board_t *board, int side_to_move);

/* Free a position that was found in the opening book */
void free_book_move(opening_position_t *entry);

/* Find successive entries for the current position */
opening_position_t *get_next_book_move(book_t *book);

void close_opening_book(book_t *book);

#endif

