#ifndef EGTB_H
#define EGTB_H

#include "game.h"
#include "heuristic.h"

extern char *tb_initinfo;

extern int initialise_tablebase(const char *path, size_t cache_size, int wdl_fraction);
extern void add_tablebase_path(const char *path);
extern unsigned int tablebase_flags(void);

#ifdef WANT_GTB
extern bool probe_hard(const board_t *board, int side_to_move, unsigned int *info, unsigned int *dtm);
extern bool probe_soft(const board_t *board, int side_to_move, unsigned int *info, unsigned int *dtm);
#else
#define probe_hard(board, side_to_move, info, dtm) false
#define probe_soft(board, side_to_move, info, dtm) false
#endif

#endif
