/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef PG_BOOK_H
#define PG_BOOK_H

#include <stdint.h>
#include "board.h"

/* Polyglot opening book entry type; really just a wrapper around a stdio
 * FILE pointer.
 */
typedef struct {
   FILE *f;
   uint64_t last_key;
   int offset;
} polyglot_book_t;

/* Entry-type in a polyglot opening book */
typedef struct {
   uint64_t key;
   uint16_t move;
   uint16_t weight;
   uint32_t learn;
} polyglot_position_t;

void entry_to_file(FILE *f, polyglot_position_t *entry);

/* Open a polyglot opening book */
polyglot_book_t *open_polyglot_opening_book(const char *filename);

/* Look up the current position in the opening book */
uint64_t get_polyglot_key(board_t *board, int side_to_move);
polyglot_position_t *get_polyglot_book_move(polyglot_book_t *book, board_t *board, int side_to_move);

/* Free a position that was found in the opening book */
void free_polyglot_book_move(polyglot_position_t *entry);

/* Find successive entries for the current position */
polyglot_position_t *get_next_polyglot_book_move(polyglot_book_t *book);

void close_polyglot_opening_book(polyglot_book_t *book);

#endif
