/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef STATIC_PSQ_H
#define STATIC_PSQ_H

#include <stdint.h>

/* Piece square tables: indexed by piece type, colour and square.
 * For the king, there are two tables: one for the early part of the game
 * and one for the end game.
 */
typedef int8_t combined_psq_t[7][2][64];

extern const combined_psq_t piece_square_table;

#endif
