/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>
#include <stdint.h>
#include "genrand.h"
#include "squares.h"

uint64_t genrand64(void)
{
   return ((uint64_t)genrandui())<<32 | genrandui();

}

int main(void)
{
   uint64_t piece_key[2][6][64];
   const char *colour_names[2] = { "White", "Black" };
   const char *piece_names[6] = { "Pawn", "Knight", "Bishop", "Rook", "Queen", "King" };
   int colour, piece, square;
   /* Key reads roughly as 'Jazz chess' */
   sgenrand(0x1422CE55);

   /* Generate hashkeys for 64 squares, 2 colours and 6 pieces */
   printf("static const uint64_t piece_key[2][6][64] = {\n");
   for (colour = 0; colour<2; colour++) {
      printf(" { /* %s */\n", colour_names[colour]);
      for(piece = 0; piece<6; piece++) {
         printf("  { /* %s */\n", piece_names[piece]);
         for(square = 0; square<64; square++) {
            piece_key[colour][piece][square] = genrand64();
            printf("0x%016llxll, ", piece_key[colour][piece][square]);
            if ( (square+1)%4 == 0) printf("\n");
         }
         printf("\n");
         printf("  },\n");
      }
      printf(" },\n");
   }
   printf("};\n");

   printf("static const uint64_t move_colour_key[2] = { 0, 0x%016llxll };\n",
            genrand64());

   /* XOR hashkeys for the moving rook, during a castling move.
    * Precomputed for convenience. The first index is the colour, the
    * second index is queen/king side
    */
   printf("static const uint64_t castle_rook_key[2][2] = {\n");
   printf(" { 0x%016llxll, 0x%016llxll }, { 0x%016llxll, 0x%016llxll }\n",
      piece_key[0][3][A1]^piece_key[0][3][D1],
      piece_key[0][3][H1]^piece_key[0][3][F1],
      piece_key[1][3][A8]^piece_key[1][3][D8],
      piece_key[1][3][H8]^piece_key[1][3][F8]);
   printf("};\n");

   return 0;
}
