/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef FEN_H
#define FEN_h

void setup_fen_position(gamestate_t *game, const char *str);

gamestate_t *load_fen_position(const char *fen);
gamestate_t *load_epd_file(const char *filename, int index);

void write_epd_file(gamestate_t *game, const char *filename);
char *make_fen_string(const gamestate_t *game, char *buffer);

#endif
