#ifndef HISTORY_H
#define HISTORY_H

#include "game.h"
#include "move.h"

#define MAX_HISTORY 16384

void update_history(gamestate_t *game, move_t move, int score);
int get_move_history_score(const gamestate_t *game, move_t move);
int get_move_history_scale(const gamestate_t *game, move_t move);
void clear_history(gamestate_t *game);
void scale_history(gamestate_t *game);

void update_history_reduction_table(gamestate_t *game, move_t move, move_t prev_move, move_t my_prev_move, int score, int alpha);
bool reduce_from_history(gamestate_t *game, move_t move, move_t prev_move, move_t my_prev_move, int static_score, int alpha);
int get_history_reduction_score(const gamestate_t *const game, move_t move);
#endif
