/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdint.h>
#include "book.h"

/* Open a polyglot opening book */
book_t *open_opening_book(const char *filename)
{
   book_t *book = NULL;

   if (!filename)
      return book;

   /* Determine the type of file. */

   /* Fallback: assume a polyglot book. */
   polyglot_book_t *pg_book = open_polyglot_opening_book(filename);
   if (pg_book) {
      book = malloc(sizeof *book);
      book->type = BOOK_FLAGS_POLYGLOT;
      book->pg = pg_book;
   }

   return book;
}

/* Look up the current position in the opening book */
opening_position_t *get_book_move(book_t *book, board_t *board, int side_to_move)
{
   if (book && book->pg) {
      return get_polyglot_book_move(book->pg, board, side_to_move);
   }

   return NULL;
}

/* Free a position that was found in the opening book */
void free_book_move(opening_position_t *entry)
{
   free_polyglot_book_move(entry);
}

/* Find successive entries for the current position */
opening_position_t *get_next_book_move(book_t *book)
{
   if (book && book->pg) {
      return get_next_polyglot_book_move(book->pg);
   }
   return NULL;
}

void close_opening_book(book_t *book)
{
   if (book && book->pg) {
      return close_polyglot_opening_book(book->pg);
      free(book);
   }
}
