/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "jazz.h"
#include "movegen.h"
#include "game.h"
#include "inline/game.h"
#include "hashtable.h"
#include "fen.h"
#include "computer.h"
#include "alphabeta.h"
#include "timer.h"
#include "evaluate.h"

int main(int argc, char **argv)
{
   gamestate_t *game = NULL;
   movelist_t movelist;

   printf("Welcome to Jazz\n");
   printf("Memory sizes:\n"
          " * move_t     : %lu bytes\n"
          " * bitboard_t : %lu bytes\n"
          " * hash_table_: %lu bytes\n"
          " * board_t    : %lu bytes\n",
          sizeof(move_t),
          sizeof(bitboard_t),
          sizeof(hash_table_entry_t),
          sizeof(board_t));
   printf("Size of transposition table: %lu bytes\n",
         sizeof(hash_table_entry_t) * HASH_TABLE_SIZE);

   printf("Initialising Jazz engine\n");
   initialise_jazz();

   if (argc>1) {
      int n;
      for (n=0; n<argc-1; n++) {
         if (strstr(argv[n+1], ".epd")) {
            game = load_epd_file(argv[n+1]);
            game->root_moves_played = game->moves_played;
            game->root_board = game->board;

            generate_moves(&movelist, game->board, game->player);
            printf("%s %d %d\n", argv[n+1],
               static_evaluation(game, WHITE, -CHECKMATE, CHECKMATE),
               static_evaluation(game, BLACK, -CHECKMATE, CHECKMATE));

            end_game(game);
         }
      }
   }
   return 0;
}
