/*  Jazz, a program for playing chess
 *  Copyright (C) 2009, 2011  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "jazz.h"
#include "gtb-probe.h"

const char **tb_paths;
size_t cache_size = 32*1024*1024; /* 32 MiB in this example */
int wdl_fraction = 96; 
char *initinfo;				/* NULL if verbosity=0, initialization info if verbosity=1*/

int main(int argc, char **argv)
{
   gamestate_t *game = NULL;
   movelist_t movelist;
   int depth = 12;

   printf("Welcome to Jazz\n");
   printf("Memory sizes:\n"
          " * move_t          : %lu bytes\n"
          " * bitboard_t      : %lu bytes\n"
          " * hash_table_entry: %lu bytes\n"
          " * pawn_structure_t: %lu bytes\n"
          " * piece__square_ta: %lu bytes\n"
          " * board_t         : %lu bytes\n",
          sizeof(move_t),
          sizeof(bitboard_t),
          sizeof(hash_table_entry_t),
          sizeof(pawn_structure_t),
          sizeof(piece_square_table_t),
          sizeof(board_t));
   printf("Size of transposition table: %lu bytes\n",
         sizeof(hash_table_entry_t) * HASH_TABLE_SIZE);

   printf("Initialising Jazz engine\n");
   initialise_jazz();

   printf("Initilaise tablebases\n");
	tb_paths = tbpaths_init();
	tb_paths = tbpaths_add(tb_paths, "../src/tb/gtb/gtb4/");

	/* init probing code, indexes, paths, etc. */
	initinfo = tb_init(1, tb_CP4, tb_paths);

	/* init cache */
	tbcache_init(cache_size, wdl_fraction); 
	tbstats_reset();

	/* information to be output for the user, or to be saved in logs etc.*/
	if (initinfo != NULL) printf ("%s",initinfo);
   unsigned av = tb_availability();

   if (0 != (av& 1)) printf ("Some 3-pc TBs available\n"); else printf ("No 3-pc TBs available\n");
   if (0 != (av& 2)) printf ("3-pc TBs complete\n");  
   if (0 != (av& 4)) printf ("Some 4-pc TBs available\n"); else printf ("No 4-pc TBs available\n");
   if (0 != (av& 8)) printf ("4-pc TBs complete\n");  
   if (0 != (av&16)) printf ("Some 5-pc TBs available\n"); else printf ("No 5-pc TBs available\n");
   if (0 != (av&32)) printf ("5-pc TBs complete\n");  
   printf ("\n");


#if 0
   if (argc>1) {
      int n;
      for (n=0; n<argc-1; n++) {
         if (strstr(argv[n+1], ".epd")) {
            game = load_epd_file(argv[n+1], 0);

            generate_moves(&movelist, game->board, game->side_to_move);
            print_bitboards(game->board);

            computer_play(game, depth);
            end_game(game);
         } else {
            int new_depth, result;
            
            result = sscanf(argv[n+1], "%d", &new_depth);
            if (result == 1)
               depth = new_depth;
         }
      }
      exit(0);
   }

   printf("Please specify file name\n");
#endif

   int tbsq[64] = {
      tb_A1, tb_B1, tb_C1, tb_D1, tb_E1, tb_F1, tb_G1, tb_H1,
      tb_A2, tb_B2, tb_C2, tb_D2, tb_E2, tb_F2, tb_G2, tb_H2,
      tb_A3, tb_B3, tb_C3, tb_D3, tb_E3, tb_F3, tb_G3, tb_H3,
      tb_A4, tb_B4, tb_C4, tb_D4, tb_E4, tb_F4, tb_G4, tb_H4,
      tb_A5, tb_B5, tb_C5, tb_D5, tb_E5, tb_F5, tb_G5, tb_H5,
      tb_A6, tb_B6, tb_C6, tb_D6, tb_E6, tb_F6, tb_G6, tb_H6,
      tb_A7, tb_B7, tb_C7, tb_D7, tb_E7, tb_F7, tb_G7, tb_H7,
      tb_A8, tb_B8, tb_C8, tb_D8, tb_E8, tb_F8, tb_G8, tb_H8
   };

   game = create_game();
   start_new_game(game);
   board_t board;
   game->board = &board;

   /* Validate KRKB heuristics */
   int hdraw = 0;
   int hwin = 0;
   int fpos = 0;
   int fposw = 0;
   int discard = 0;
   int wins = 0, losss = 0, draws = 0;
   int aks, dks, bs, rs;
   int ww[2] = { 0, 0 };
   if (0)
   for(aks = A1; aks<=H8; aks++) {
      for(dks = A1; dks<=H8; dks++) {
         if (aks == dks) continue;
         if (king_attack[aks] & make_bitboard_square(dks)) continue;
         for(bs = A1; bs<=H8; bs++) {
            if (aks == bs) continue;
            if (dks == bs) continue;
            for(rs = A2; rs<=H8; rs++) {
               if (aks == rs) continue;
               if (dks == rs) continue;
               if (bs == rs) continue;
               if (bs == rs) continue;

               for (int side_to_move = 0; side_to_move < 2; side_to_move++) {
                  memset(&board, 0, sizeof board);

                  game->side_to_move = side_to_move * BLACK;

                  /* Place the pieces on the board */
                  board.bbc[0] = make_bitboard_square(aks);
                  board.bbc[1] = make_bitboard_square(dks);
                  board.bbp[KING] = get_occupied(&board);
                  board.bbp[ROOK] = make_bitboard_square(rs);
                  board.bbp[BISHOP] = make_bitboard_square(bs);
                  board.bbc[0] |= board.bbp[ROOK];
                  board.bbc[1] |= board.bbp[BISHOP];

                  int other = WHITE;
                  if (side_to_move == 0) other = BLACK;
                  if (player_in_check(game, other)) continue;

                  if (player_in_check(game, game->side_to_move)) {
                     discard++;
                     continue;
                  }

                  //print_board(&board);

                  /* Probe tablebase */
                  unsigned int  stm;		/* side to move */
                  unsigned int  wsq[17];	/* list of squares for white */
                  unsigned int  bsq[17];	/* list of squares for black */
                  unsigned char wp[17];	/* what white pieces are on those squares */
                  unsigned char bp[17];	/* what black pieces are on those squares */
                  int tb_available;			/* 0 => FALSE, 1 => TRUE */
                  unsigned info = tb_UNKNOWN;	/* default, no tbvalue */
                  unsigned pliestomate;	

                  for (int n = 0; n<17; n++) {
                     wsq[n] = bsq[n] = tb_NOSQUARE;
                     wp[n] = bp[n] = tb_NOPIECE;
                  }

                  if (side_to_move == 0)
                     stm = tb_WHITE_TO_MOVE;
                  else
                     stm = tb_BLACK_TO_MOVE;

                  wsq[0] = tbsq[aks];
                  wsq[1] = tbsq[rs];

                  wp[0] = tb_KING;
                  wp[1] = tb_ROOK;

                  bsq[0] = tbsq[dks];
                  bsq[1] = tbsq[bs];

                  bp[0] = tb_KING;
                  bp[1] = tb_BISHOP;

                  tb_available = tb_probe_hard (stm, tb_NOSQUARE, tb_NOCASTLE, wsq, bsq, wp, bp, &info, &pliestomate);
                  if (!tb_available) {
                     printf("Table base not available, abort.\n");
                     exit(0);
                  }

                  if (info == tb_DRAW) draws++;
                  if (info == tb_WMATE) wins++;
                  if (info == tb_BMATE) losss++;

                  if (info != tb_DRAW) ww[side_to_move]++;

                  if (heuritsic_krkb(&board, side_to_move) == heuristic_draw) {
                     hdraw++;
                     if (info != tb_DRAW) {
                        fpos++;
                        printf("False positive (draw should be win) %s\n", make_fen_string(game, NULL));
                        print_board(&board);
                        exit(0);
                     }
                  }
                  if (heuritsic_krkb(&board, side_to_move) == heuristic_win) {
                     hwin++;
                     ww[side_to_move]--;
                     if (info != tb_WMATE) {
                        fposw++;
                        printf("False positive (win should be draw) %s\n", make_fen_string(game, NULL));
                        print_board(&board);
                        exit(0);
                     }
                  }
                  if (heuritsic_krkb(&board, side_to_move) == heuristic_loss) {
                     hwin++;
                     ww[side_to_move]--;
                     if (info != tb_WMATE) {
                        fposw++;
                        printf("False positive (win should be draw) %s\n", make_fen_string(game, NULL));
                        print_board(&board);
                        exit(0);
                     }
                  }
               }
            }
         }
      }
   }

   int n_tot = draws+wins+losss;
   printf("%10d total positions\n", n_tot+discard);
   printf("%10d in-check positions discarded\n", discard);
   printf("%10d draws  (% .2f%%)\n", draws, 100. * draws / n_tot);
   printf("%10d wins   (% .2f%%)\n", wins, 100. * wins / n_tot);
   printf("%10d losses (% .2f%%)\n", losss, 100. * losss / n_tot);
   printf("Heuristics:\n");
   printf("%10d draws (% .2f%% of tablebase)\n", hdraw, 100.*hdraw / draws);
   printf("%10d false positives (% .2f%%)\n", fpos, 100.*fpos / hdraw);
   printf("%10d wins (% .2f%% of tablebase)\n", hwin, 100.*hwin / wins);
   printf("%10d false positives (% .2f%%)\n", fposw, 100.*fposw / hwin);
   printf("%10d real wins (% .2f%% of tablebase)\n", hwin-fposw, 100.*(hwin-fposw) / wins);
   printf("%10d WTM wins missed\n", ww[0]);
   printf("%10d BTM wins missed\n", ww[1]);

   printf("Test positions where the position of the bishop is irrelevant\n");
   for (int side_to_move = 0; side_to_move < 1; side_to_move++) {
      for(aks = A1; aks<=H8; aks++) {
         if (aks > H4) continue;
         for(dks = A1; dks<=H8; dks++) {
            if (aks == dks) continue;
            if (king_attack[aks] & make_bitboard_square(dks)) continue;
            if (dks >=A5) continue;
            if (unpack_file(dks) > 3) continue;
            for(rs = A1; rs<=H8; rs++) {
               if (aks == rs) continue;
               if (dks == rs) continue;
               bool first = true;
               bool all_same = true;
               int first_result = tb_WMATE;
               bool all_sameh = true;
               int first_resulth = heuristic_win;
               int last_resulth = heuristic_win;
               for(bs = A1; bs<=H8; bs++) {
                  if (aks == bs) continue;
                  if (dks == bs) continue;
                  if (bs == rs) continue;

                  if (board_light & make_bitboard_square(bs)) continue;
                  if (!all_same) break;

                  memset(&board, 0, sizeof board);

                  game->side_to_move = side_to_move * BLACK;

                  /* Place the pieces on the board */
                  board.bbc[0] = make_bitboard_square(aks);
                  board.bbc[1] = make_bitboard_square(dks);
                  board.bbp[KING] = get_occupied(&board);
                  board.bbp[ROOK] = make_bitboard_square(rs);
                  board.bbp[BISHOP] = make_bitboard_square(bs);
                  board.bbc[0] |= board.bbp[ROOK];
                  board.bbc[1] |= board.bbp[BISHOP];

                  int other = WHITE;
                  if (side_to_move == 0) other = BLACK;
                  if (player_in_check(game, other)) {
                     all_same = false;
                     continue;
                  }

                  if (player_in_check(game, game->side_to_move)) {
                     discard++;
                     all_same = false;
                     continue;
                  }

                  //print_board(&board);

                  /* Probe tablebase */
                  unsigned int  stm;		/* side to move */
                  unsigned int  wsq[17];	/* list of squares for white */
                  unsigned int  bsq[17];	/* list of squares for black */
                  unsigned char wp[17];	/* what white pieces are on those squares */
                  unsigned char bp[17];	/* what black pieces are on those squares */
                  int tb_available;			/* 0 => FALSE, 1 => TRUE */
                  unsigned info = tb_UNKNOWN;	/* default, no tbvalue */
                  unsigned pliestomate;	

                  for (int n = 0; n<17; n++) {
                     wsq[n] = bsq[n] = tb_NOSQUARE;
                     wp[n] = bp[n] = tb_NOPIECE;
                  }

                  if (side_to_move == 0)
                     stm = tb_WHITE_TO_MOVE;
                  else
                     stm = tb_BLACK_TO_MOVE;

                  wsq[0] = tbsq[aks];
                  wsq[1] = tbsq[rs];

                  wp[0] = tb_KING;
                  wp[1] = tb_ROOK;

                  bsq[0] = tbsq[dks];
                  bsq[1] = tbsq[bs];

                  bp[0] = tb_KING;
                  bp[1] = tb_BISHOP;

                  tb_available = tb_probe_hard (stm, tb_NOSQUARE, tb_NOCASTLE, wsq, bsq, wp, bp, &info, &pliestomate);
                  if (!tb_available) {
                     printf("Table base not available, abort.\n");
                     exit(0);
                  }

                  int h = heuritsic_krkb(&board, side_to_move);
                  if (h == heuristic_loss) h = heuristic_win;

                  if (first) {
                     first = false;
                     first_result = info;
                     first_resulth = h;
                  }

                  if (all_sameh) last_resulth = h;
                  all_same = all_same & (first_result == info);
                  all_sameh = all_sameh & (first_resulth == h);

                  if (0)
                  if (all_same && !all_sameh) {
                     printf("Pattern breaks down:\n");
                     print_board(&board);
                  }
               }

               if (all_same && !all_sameh) {
                  printf("Bishop position irrelevant for this pattern:\n");
                  print_board(&board);
                  printf("%d %d\n", side_to_move, first_result);
                  printf("%d %d\n", all_sameh, first_resulth, last_resulth);
               }
            }
         }
      }
   }

   return 0;
}
