/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef PIECES_H
#define PIECES_H

#include <stdint.h>

/* Bitfield colours */
typedef enum sides { NONE=-1, WHITE, BLACK, NUM_SIDES } sides;
static const sides next_side[NUM_SIDES] = { BLACK, WHITE };

/* Aliases */
#define PERSIAN WHITE
#define SPARTAN BLACK

/* Pieces */
#define MAX_PIECE_TYPES 16
typedef enum pieces { WPAWN=0, KNIGHT, BISHOP, ROOK, QUEEN, KING,
                 BHOPLITE, LIEUTENANT, CAPTAIN, GENERAL, WARLORD, BASILEUS,
                 MARSHAL, NUM_PIECES } pieces;

/* Alternate piece names, for Seirawan chess */
#define HAWK      WARLORD
#define ELEPHANT  MARSHAL

#define NO_PROMOTION    0
#define ANY_PROMOTION   (1<<KNIGHT | 1<<BISHOP | 1<<ROOK | 1<<QUEEN |\
                         1<<LIEUTENANT | 1<<CAPTAIN | 1<<GENERAL | 1<<WARLORD | 1<<BASILEUS |\
                         1<<MARSHAL)
#define QUE_PROMOTION   (1<<KNIGHT | 1<<QUEEN | 1<<GENERAL | 1<<WARLORD | 1<<BASILEUS | 1<<MARSHAL)
#define KING_PROMOTION  (1<<BASILEUS)

extern uint16_t promotion_options[NUM_SIDES];

extern const char *white_piece_string;
extern const char *black_piece_string;
extern const char *piece_symbol_string;
extern const char *piece_name[];

static inline uint8_t piece_for_side(int piece, sides side)
{
   return piece | (side << 4);
}

#if NUM_PIECES >= MAX_PIECE_TYPES
   #error Too many pieces defined
#endif

#endif
