/*  Leonidas, a program for playing chess variants
 *  Copyright (C) 2013  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>

#include "leonidas.h"

#define streq(s1, s2) (strcmp((s1), (s2)) == 0)

static game_t *(*new_variant_game)(void) = create_spartan_game;

int main(int argc, char **argv)
{
   game_t *game = NULL;
   int depth = 12;

   initialise_leonidas();

   if (argc>1) {
      int n;
      for (n=1; n<argc; n++) {
         if (strstr(argv[n], "-variant")) {
            if (n+1 >= argc) {
               fprintf(stderr, "error: -variant passed, but no variant specified");
               exit(0);
            }
            n++;

            char *input = argv[n];
            if (streq(input, "normal")) {
               new_variant_game = create_standard_game;
            } else if (streq(input, "spartan")) {
               new_variant_game = create_spartan_game;
            } else if (streq(input, "seirawan")) {
               new_variant_game = create_seirawan_game;
            } else {
               fprintf(stderr, "error: variant '%s' unknown\n", input);
               exit(0);
            }
            if (game) {
               end_game(game);
            }
            game = new_variant_game();
            start_new_game(game);
         } else if (strstr(argv[n], ".epd")) {
            char fen[4096];
            FILE *f;

            if (!game) {
               game = new_variant_game();
            }

            f = fopen(argv[n], "r");
            fgets(fen, sizeof fen, f);
            fclose(f);

            start_new_game(game);
            setup_fen_position(game, fen);

            print_bitboards(&game->board);
            set_infinite_time(game);
            computer_play(game, depth);
         } else {
            int new_depth, result;
            
            result = sscanf(argv[n], "%d", &new_depth);
            if (result == 1)
               depth = new_depth;
         }
      }

      return 0;
   }

   if (!game) {
      game = new_variant_game();
      start_new_game(game);
   }

   print_bitboards(&game->board);

   movelist_t movelist;
   generate_moves(&movelist, &game->board, WHITE);
   printf("%d\n", movelist.num_moves);
   for (int n = 0; n<movelist.num_moves; n++)
      printf("%s ", short_move_string(&game->board, movelist.move[n], NULL));
   printf("\n");


   return 0;
}

