/*  Sjaak, a program for playing chess
 *  Copyright (C) 2011, 2014  Evert Glebbeek
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define SAFE_MOB_WEIGHT        8       // Weight for safe mobility squares
#define MOB_SCALE             16       // Overall mobility weight
#define MOB_FORWARD_BLOCKED    5       // Penalty for forward mobility blocked by pieces

#define KS_ATTACK_WEIGHT    256
#define KS_SHELTER_WEIGHT    32
#define KING_SAFETY_WEIGHT  416        // Overall scale-factor for king safety
// Weight vs. STS score:
// 512 (3126)
// 256 (3044)
// 384 (3118)
// 448 (3117)
// 416 (3128)

#define PST_HOLDINGS          5        // PST value for a piece in holdings

#define PST_SPACE_MG          5        // PST value for empty squares on the own side of the board

#define PASSER_RANK_SCALE     4

#define ROOK_BASE_PAWN_MG     5        // Bonus for a rook that attacks base of enemy pawn structure, middle game
#define ROOK_BASE_PAWN_EG    10        // Bonus for a rook that attacks base of enemy pawn structure, end game

#define WEAK_PAWN_BASE_MG     5        // Penalty for a weak pawn, middle game
#define WEAK_PAWN_BASE_EG    10        // Penalty for a weak pawn, end game

#define LOOSE_MINOR_PENALTY   5        // Penalty for an undefended minor on the enemy side of the board

#define PAIR_BONUS_MG         0.10     // Fraction of piece value
#define PAIR_BONUS_EG         0.15     // Fraction of piece value

#define SLIDER_OPENFILE_MG   10        // Slider bonus on open file, middle game
#define SLIDER_OPENFILE_EG   15        // Slider bonus on open file, end game

#define DEF_PROTECT           7        // Bonus for defensive pieces that protect eachother
#define DEF_SHIELD_FILE      10        // Bonus for defensive pieces on king file

#define FUTILITY_DEPTH        3

#define PAWN_SCALE_MG         0.8      // Fraction of nominal piece value
#define LAME_SCALE_MG         0.9      // Fraction of nominal piece value
#define LAME_SCALE_EG         1.1      // Fraction of nominal piece value
#define HOP_SCALE_EG          0.7      // Fraction of nominal piece value
